// 物品白名单
const whitelist = Ingredient.matchAny([
    'kubejs:copper_coin', //单个物品
    'kubejs:iron_coin',//单个物品
    '@create', //mod物品示例
    'kubejs:diamond_coin',
    'kubejs:gold_coin',
    'kubejs:cure_syringe',
    'kubejs:white_crystal_core',
    'kubejs:second_brain_core',
    'kubejs:brain_core',
    'kubejs:vaccine_zombie',
    'kubejs:shadow_of_god'
])
// 执行一次间隔（注：该值必须大于1）
const minutes = 30;

// ======================================

var lastResult = [];
var totalResult = [];
var lastItemCount = 0;
var totalItemCount = 0;


function clearLag(server){
    lastResult = [];
    lastItemCount = 0;
    server.getEntities("@e[type=item]").forEach(entity => {
        if (!whitelist.test(entity.item.id)){
            lastResult.push([entity.item.id, entity.item.count]);
            totalResult.push([entity.item.id, entity.item.count]);
            lastItemCount += entity.item.count;
            entity.kill();
        }
    });
    lastResult.sort();
    totalResult.sort();
    server.tell([Component.translate('item.kubejs.clear.1'), ' |', Component.translate('item.kubejs.clear.2'), Text.green(` ${lastItemCount}`), Component.translate('item.kubejs.clear.5')]);
}

function countResult(result,event){
    if(result != []){
        result.forEach((singleResult, index) => {
        event.server.tell([Text.lightPurple(`第 ${index + 1} 项 `), `${singleResult[0]} , 个数为 ${singleResult[1]}`])
        })
    }
}

onEvent('server.load', function (event) {
    event.server.scheduleInTicks(100, event.server, function (callback0) {
        callback0.data.tell([Component.translate('item.kubejs.clear.1'), ' |', Component.translate('item.kubejs.clear.3')]);
    })
    event.server.schedule((minutes - 1) * MINUTE, event.server, function (callback1) {
        callback1.data.tell([Component.translate('item.kubejs.clear.1'), ' |', Component.translate('item.kubejs.clear.4')]);
        callback1.data.schedule(MINUTE, callback1.data, function(callback2) {
            clearLag(callback2.data);
        })
        callback1.reschedule();
    })
})

